<?php
/*
 * lang_update.php
 * 
 * 用于在 OPNsense 上进行汉化的web程序。
 * 版权所有 (c) 2025 by pfchina.org
 */
require_once("guiconfig.inc");
include("head.inc");
include("fbegin.inc");

$log_output = '';
$readme_output = '';

// 获取当前 OPNsense 版本
$current_version = '';
$versionFile = "/usr/local/opnsense/version/core";
if (file_exists($versionFile)) {
    $content = file_get_contents($versionFile);
    if (preg_match('/"CORE_PKGVERSION":\s*"([^"]+)"/', $content, $matches)) {
        $current_version = $matches[1];
    }
}

function executeCommand($command) {
    exec($command . ' 2>&1', $output, $returnVar);
    return ['output' => $output, 'status' => $returnVar];
}

function finalizeUpdate($tmpDir, &$log_output) {
    if (is_dir($tmpDir)) {
        executeCommand("rm -rf " . escapeshellarg($tmpDir));
        executeCommand("rm -rf /usr/local/readme.md");
        $log_output .= gettext("🧹 清理临时文件...") . "\n";
    }

    // 重启 Web GUI
    executeCommand("nohup configctl webgui restart >/dev/null 2>&1 &");
    $log_output .= gettext("🔄 重启 Web GUI...") . "\n";
}

function ensureDirectory($dir, &$log_output) {
    if (!is_dir($dir) && !mkdir($dir, 0777, true) && !is_dir($dir)) {
        $log_output .= gettext("❌ 无法创建临时目录: ") . htmlspecialchars($dir) . "\n";
        return false;
    }
    return true;
}

if ($_POST) {
    $tmpDir = "/tmp/lang";
    $archive = "$tmpDir/lang.zip";
    $readmeFile = "$tmpDir/readme.md";

    $downloadUrl = trim($_POST['download_url'] ?? 'https://cloud.pfchina.org/index.php/s/CYFKMKGY7spK7mj/download?path=%2FOPNsense&files=lang.zip');
    
    if (!filter_var($downloadUrl, FILTER_VALIDATE_URL)) {
        $log_output .= gettext("❌ 无效的下载链接！请提供正确的 URL。") . "\n";
    } else {
        if (!ensureDirectory($tmpDir, $log_output)) {
            // Error message handled in ensureDirectory
        } else {
            $downloadResult = executeCommand("fetch -o " . escapeshellarg($archive) . " " . escapeshellarg($downloadUrl));
            if ($downloadResult['status'] !== 0) {
                $log_output .= gettext("❌ 下载失败！请检查下载地址是否正确。") . "\n";
                $log_output .= implode("\n", (array)$downloadResult['output']) . "\n";
                finalizeUpdate($tmpDir, $log_output);
            } else {
                $log_output .= gettext("📥 下载完成") . "\n";

                $extractResult = executeCommand("unzip -o " . escapeshellarg($archive) . " -d " . escapeshellarg($tmpDir));
                if ($extractResult['status'] !== 0) {
                    $log_output .= gettext("❌ 解压失败！请检查文件是否正确。") . "\n";
                    $log_output .= implode("\n", (array)$extractResult['output']) . "\n";
                    finalizeUpdate($tmpDir, $log_output);
                } else {
                    $log_output .= gettext("📂 解压完成") . "\n";

                    $installResult = executeCommand("unzip -o " . escapeshellarg($archive) . " -d /usr/local/");
                    if ($installResult['status'] !== 0) {
                        $log_output .= gettext("❌ 汉化文件覆盖失败！请检查权限或路径。") . "\n";
                        $log_output .= implode("\n", (array)$installResult['output']) . "\n";
                        finalizeUpdate($tmpDir, $log_output);
                    } else {
                        $log_output .= gettext("✅ 汉化完成...") . "\n";
                        if (file_exists($readmeFile)) {
                            $readme_output = file_get_contents($readmeFile);
                            finalizeUpdate($tmpDir, $log_output);
                        } else {
                            $readme_output = gettext("❗ 未找到 `readme.md`，请检查汉化包内容。");
                            finalizeUpdate($tmpDir, $log_output);
                        }
                        // 添加汉化信息
                        $versionFile = "/usr/local/opnsense/version/core";
                        if (file_exists($versionFile)) {
                            $content = file_get_contents($versionFile);
                            $content = str_replace('"product_copyright_owner": "Deciso B.V."', '"product_copyright_owner": "【汉化】：鐵血男兒"', $content);
                            $content = str_replace('"product_copyright_url": "https://www.deciso.com/"', '"product_copyright_url": "https://pfchina.org/"', $content);
                            file_put_contents($versionFile, $content);
                        } else {
                        }
                    }
                }
            }
        }
    }
}
?>

<section class="page-content-main">
    <div class="container-fluid">
        <div class="row">
            <section class="col-xs-12">
                <form method="post" id="updateForm">
                    <!-- 操作面板 -->
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h2 class="panel-title"><?php echo gettext("汉化补丁"); ?></h2>
                        </div>
                        <div class="panel-body">
                            <div class="form-group">
                                <label for="download_url"><?php echo gettext("下载链接："); ?></label>
                                <input type="url" name="download_url" id="download_url" class="form-control"
                                       value="https://cloud.pfchina.org/index.php/s/CYFKMKGY7spK7mj/download?path=%2FOPNsense&files=lang.zip"
                                       required pattern="https://.*">
                            </div>
                            <button type="submit" class="btn btn-primary" id="updateBtn">
                                <i class="fa fa-download"></i> <?php echo gettext('开始汉化'); ?>
                            </button>
                            <br><br>
                            <?php if (!empty($log_output)): ?>
                                <pre class="log-box"><?php echo htmlspecialchars($log_output); ?></pre>
                            <?php endif; ?>
                            <?php if (!empty($readme_output)): ?>
                                <pre class="readme-box"><?php echo htmlspecialchars($readme_output); ?></pre>
                            <?php endif; ?>
                        </div>
                    </div>
                </form>
                <script>
                    document.getElementById("updateForm").addEventListener("submit", function(event) {
                        document.getElementById("updateBtn").disabled = true;
                    });
                </script>
                <style>
                    .log-box, .readme-box {
                        background: #f4f4f4;
                        padding: 10px;
                        border-radius: 5px;
                        white-space: pre-wrap;
                    }
                </style>
            </section>
        </div>
    </div>
</section>

<?php include 'foot.inc'; ?>
