<?php
/*
 * diag_pftop.php
 *
 * pftop的We控制界面，用于显示流量的各种信息。
 * 版权所有 (c) 2025 by pfchina.org
 */
require_once("guiconfig.inc");
include("head.inc");
include("fbegin.inc");

$pftop = "/usr/local/sbin/pftop";

if (!file_exists($pftop)) {
    $pftop = "/usr/bin/pftop";
}

// 可选的排序方式、查看模式和条目数
$排序方式 = ['age', 'bytes', 'dest', 'dport', 'exp', 'none', 'pkt', 'sport', 'src'];
$查看模式 = ['default', 'label', 'long', 'queue', 'rules', 'size', 'speed', 'state', 'time'];
$条目数 = ['50', '100', '200', '500', '1000', 'all'];

function 获取参数($参数名, $有效值, $默认值) {
    return in_array($_REQUEST[$参数名] ?? null, $有效值) ? $_REQUEST[$参数名] : $默认值;
}

// 生成下拉菜单选项
function 生成下拉选项($name, $options, $selected) {
    $html = '';
    foreach ($options as $option) {
        $safeOption = htmlspecialchars($option, ENT_QUOTES, 'UTF-8');
        $html .= "<option value='{$safeOption}' " . ($selected == $option ? 'selected' : '') . ">" . gettext(ucfirst($option)) . "</option>";
    }
    return $html;
}

// 生成表单下拉框
function 生成表单下拉框($name, $label, $options, $selected) {
    return "
        <label for='{$name}'>{$label}</label>
        <select name='{$name}' id='{$name}' onchange='提交表单()'>
            " . 生成下拉选项($name, $options, $selected) . "
        </select>
    ";
}

// 获取用户参数
$参数 = [
    '排序' => 获取参数('排序', $排序方式, 'bytes'),
    '模式' => 获取参数('模式', $查看模式, 'default'),
    '条目' => 获取参数('条目', $条目数, '100')
];
$排序 = $参数['排序'];
$模式 = $参数['模式'];
$条目 = $参数['条目'];

$过滤 = $_REQUEST['过滤'] ?? '';
$过滤 = $过滤 !== "" ? "-f " . escapeshellarg($过滤) : '';

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['ajax']) && $_GET['ajax'] == 'true') {
    if (in_array($模式, ['queue', 'label', 'rules'])) {
        $排序 = "";
        $条目 = "-a";
    } else {
        $排序 = "-o " . escapeshellcmd($排序);
        $条目 = ($条目 == "all" ? "-a" : escapeshellarg($条目));
    }

    // 生成最终命令
    $命令 = "$pftop {$过滤} -b {$排序} -w 135 -v {$模式} {$条目}";
    echo "<div id=\"结果预览\">";
    echo "<pre style=\"width: 100%; overflow-x: auto\">执行命令: {$命令}</pre>";

    // 执行命令并显示结果
    $输出 = shell_exec($命令);
    echo "<pre style=\"width: 100%; overflow-x: auto\">" . htmlspecialchars($输出) . "</pre>";
    echo "</div>";
    exit;
}
?>

<section class="page-content-main">
    <div class="container-fluid">
        <div class="row">
            <section class="col-xs-12">
                <div class="content-box tab-content table-responsive __mb">
                    <table class="table table-striped">
                        <tbody>
                            <tr>
                                <td><strong><?= gettext("pfTop 配置") ?></strong></td>
                            </tr>
                            <tr>
                                <td>
                                    <form id="pftop表单">
                                        <input type="hidden" name="ajax" value="true">
                                        <?= 生成表单下拉框('模式', gettext('查看模式'), $查看模式, $模式); ?>
                                        <br>
                                        <label for="过滤"><?= gettext('过滤条件'); ?></label>
                                        <input type="text" name="过滤" id="过滤"
                                            value="<?= htmlspecialchars($_REQUEST['过滤'] ?? ''); ?>"
                                            placeholder="示例: tcp, ip6, dst net 208.123.73.0/24">
                                        <br>
                                        <?= 生成表单下拉框('排序', gettext('排序方式'), $排序方式, $排序); ?>
                                        <br>
                                        <?= 生成表单下拉框('条目', gettext('显示数量'), $条目数, $条目); ?>
                                        <br>
                                    </form>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </section>

            <section class="col-xs-12">
                <div class="content-box tab-content table-responsive __mb">
                    <table class="table table-striped">
                        <tbody>
                            <tr>
                                <td><strong><?= gettext('输出结果:'); ?></strong></td>
                            </tr>
                        </tbody>
                    </table>
                    <div id="结果区域" style="margin: 8px"></div>
                </div>
            </section>
        </div>
    </div>
</section>

<script>
    let 定时器;
    function 提交表单() {
        clearTimeout(定时器);
        定时器 = setTimeout(() => {
            document.getElementById("结果区域").innerHTML = "<p>加载中...</p>";
            const formData = new FormData(document.getElementById("pftop表单"));

            fetch("/diag_pftop.php?" + new URLSearchParams(formData))
                .then(response => response.text())
                .then(data => {
                    const 解析HTML = new DOMParser().parseFromString(data, "text/html");
                    const 结果内容 = 解析HTML.querySelector("#结果预览")?.innerHTML || "<p>未获取到数据。</p>";
                    document.getElementById("结果区域").innerHTML = 结果内容;
                })
                .catch(error => {
                    document.getElementById("结果区域").innerHTML = `<p style="color:red;">错误: ${error.message}</p>`;
                    console.error('请求错误:', error);
                });
        }, 300);
    }

    document.querySelectorAll('#模式, #排序, #条目, #过滤').forEach(function (元素) {
        元素.addEventListener('change', 提交表单);
    });

    document.getElementById("过滤").addEventListener("keypress", function (event) {
        if (event.key === "Enter") {
            event.preventDefault();
            提交表单();
        }
    });

    提交表单();
</script>

<?php include("foot.inc"); ?>
