<?php
/*
 * diag_command.php
 * 
 * 用于在 OPNsense 上执行 Shell 命令，以及上传和下载文件。
 * 版权所有 (c) 2025 by pfchina.org
 */
require_once("guiconfig.inc");
include("head.inc");
include("fbegin.inc");

// 定义常量
define("UPLOAD_DIR", "/tmp/uploads");

// 初始化变量
$input_errors = [];
$success_message = '';

// 清理用户输入
function sanitize_input($data)
{
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

// 检查路径是否合法
function validate_path($path, $allowed_dir)
{
    $real_path = realpath($path);
    return $real_path && strpos($real_path, $allowed_dir) === 0;
}

// 处理文件上传
if ($_POST['submit'] === "UPLOAD" && is_uploaded_file($_FILES['ulfile']['tmp_name'])) {
    @mkdir(UPLOAD_DIR, 0755, true);
    $file_name = basename($_FILES['ulfile']['name']);
    if (preg_match('/^[a-zA-Z0-9._-]+$/', $file_name)) {
        $upload_path = UPLOAD_DIR . "/" . $file_name;
        if (move_uploaded_file($_FILES['ulfile']['tmp_name'], $upload_path)) {
            $success_message = sprintf(gettext("文件已成功上传到 %s。"), htmlentities($upload_path));
        } else {
            $input_errors[] = gettext("文件上传失败。");
        }
    } else {
        $input_errors[] = gettext("文件名包含非法字符，上传失败。");
    }
}

// 处理文件下载
if ($_POST['submit'] === "DOWNLOAD" && !empty($_POST['dlPath'])) {
    $dl_path = sanitize_input($_POST['dlPath']);
    if (validate_path($dl_path, UPLOAD_DIR) && file_exists($dl_path)) {
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . basename($dl_path) . '"');
        readfile($dl_path);
        exit;
    } else {
        $input_errors[] = gettext("文件路径非法或文件不存在。");
    }
}
?>

<section class="page-content-main">
    <div class="container-fluid">
        <div class="row">
            <!-- 文件上传部分 -->
            <section class="col-xs-12">
                <div class="content-box tab-content table-responsive __mb">
                    <table class="table table-striped">
                        <tbody>
                            <tr>
                                <td>
                                    <strong><?= gettext("上传文件") ?></strong>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <form method="post" action="diag_command.php" enctype="multipart/form-data" class="form-inline">
                                        <div class="form-group">
                                            <label for="ulfile" class="control-label"><?= gettext("选择要上传的文件") ?>:</label>
                                            <input type="file" name="ulfile" id="ulfile" class="form-control">
                                        </div>
                                        <button type="submit" name="submit" value="UPLOAD" class="btn btn-primary">
                                            <?= gettext("上传") ?>
                                        </button>
                                    </form>
                                    <!-- 提示信息显示 -->
                                    <?php if ($_POST['submit'] === "UPLOAD"): ?>
                                        <?php if (!empty($input_errors)): ?>
                                            <?php print_input_errors($input_errors); ?>
                                        <?php elseif (!empty($success_message)): ?>
                                            <?php print_info_box($success_message, 'success'); ?>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </section>

            <!-- 文件下载部分 -->
            <section class="col-xs-12">
                <div class="content-box tab-content table-responsive __mb">
                    <table class="table table-striped">
                        <tbody>
                            <tr>
                                <td>
                                    <strong><?= gettext("下载文件") ?></strong>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <form method="post" action="diag_command.php" class="form-inline">
                                        <div class="form-group">
                                            <label for="dlPath" class="control-label"><?= gettext("输入要下载的文件路径") ?>:</label>
                                            <input type="text" name="dlPath" id="dlPath" class="form-control"
                                                placeholder="/tmp/uploads/example.txt">
                                        </div>
                                        <button type="submit" name="submit" value="DOWNLOAD" class="btn btn-warning">
                                            <?= gettext("下载") ?>
                                        </button>
                                    </form>
                                    <!-- 提示信息显示 -->
                                    <?php if ($_POST['submit'] === "DOWNLOAD"): ?>
                                        <?php if (!empty($input_errors)): ?>
                                            <?php print_input_errors($input_errors); ?>
                                        <?php elseif (!empty($success_message)): ?>
                                            <?php print_info_box($success_message, 'success'); ?>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </section>
            <!-- Shell命令部分 -->
            <section class="col-xs-12">
                <div class="content-box tab-content table-responsive __mb">
                    <table class="table table-striped">
                        <tbody>
                            <tr>
                                <td>
                                    <strong><?= gettext("命令行工具") ?></strong>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <form method="post" action="diag_command.php" class="form-inline">
                                        <div class="form-group">
                                            <label for="txtCommand" class="control-label"><?= gettext("输入Shell命令") ?>:</label>
                                            <input type="text" name="txtCommand" id="txtCommand" class="form-control"
                                                placeholder="例如：ls -la">
                                        </div>
                                        <button type="submit" name="submit" value="EXEC" class="btn btn-success">
                                            <?= gettext("执行") ?>
                                        </button>
                                    </form>
                                    <!-- 提示信息显示 -->
                                    <?php if ($_POST['submit'] === "EXEC" && !empty($input_errors)): ?>
                                        <?php print_input_errors($input_errors); ?>
                                    <?php endif; ?>
                                    <?php if ($_POST['submit'] === "EXEC" && !empty($_POST['txtCommand'])): ?>
                                    <div class="form-group mt-3">
                                        <label><strong><?= gettext("命令输出") ?>:</strong></label>
                                        <pre class="bg-light p-3">
                                   <?php
                                        $output = [];
                                        $command = escapeshellcmd($_POST['txtCommand']);
                                        exec($command . " 2>&1", $output);
                                       echo htmlentities(implode("\n", $output));
                                      ?>
                                        </pre>
                                    </div>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </section>
        </div>
    </div>
</section>            
<?php
include("foot.inc");
?>
