#!/bin/bash
echo -e ''
echo -e "\033[32m============ OPNsense 命令行、pftop、汉化工具安装脚本 ==============\033[0m"
echo -e ''

# 定义颜色变量
GREEN="\033[32m"
YELLOW="\033[33m"
RED="\033[31m"
CYAN="\033[36m"
RESET="\033[0m"

# 定义目录变量
ROOT="/usr/local"
WWW_DIR="$ROOT/www"
MENU_DIR="$ROOT/opnsense/mvc/app/models/OPNsense"


# 定义日志函数
log() {
    local color="$1"
    local message="$2"
    echo -e "${color}${message}${RESET}"
}

# 复制文件
log "$YELLOW" "复制文件..."
log "$YELLOW" "生成菜单..."
cp -f www/* "$WWW_DIR/" || log "$RED" "www 文件复制失败！"
cp -R menu/* "$MENU_DIR/" || log "$RED" "menu 文件复制失败！"

# 删除菜单缓存
rm -f /var/lib/php/tmp/opnsense_menu_cache.xml
rm -f /var/lib/php/tmp/opnsense_acl_cache.json


# 完成提示
log "$GREEN" "安装完成，请导航到服务 > 其他工具菜单进行操作。"
echo ""